#pragma once

#include <UnitDriveInterface.hpp>
#include <Arduino.h>
#include <SensirionI2cSht4x.h>
#include <Wire.h>
#include <LovyanGFX.hpp>

class SHT4xDrive : public UnitDriveInterface
{
public:
    SHT4xDrive(TwoWire &wire=Wire, lgfx::LGFX_Device *lcd=nullptr);
    ~SHT4xDrive();
    virtual void probe() override;
    virtual void init() override;
    virtual void deinit() override;
    virtual void run() override;
    uint32_t readSerialNumber();
private:
    void onProbeView();
    void onInitView();
    void onInitailizeView();
    void onDeinitView();
    void onRunView();
    lgfx::LGFX_Device *_lcd;
    TwoWire *_wire;
    SensirionI2cSht4x *_sht4x;
    UnitStatus _status = UNIT_STATUS_UNKNOWN;
    float aTemperature;
    float aHumidity;
};