#include <Arduino.h>
#include <LovyanGFX.hpp>
#include <cstdio>
#include <memory>
#include "logo.h"
#include "SHT3xDrive.hpp"
#include "SHT4xDrive.hpp"

// Use the Arduino IDE, you need to define one of the following macros to select the sensor type
#define FPC_SHT30
// #define FPC_SHT40

class C3GFX: public lgfx::LGFX_Device {
    lgfx::Panel_SSD1306 _panel_instance;
    lgfx::Bus_I2C       _i2c_bus_instance;

public:

    C3GFX() {
        {
            auto cfg = _i2c_bus_instance.config();
            cfg.i2c_port = 0;
            cfg.pin_sda = 8;
            cfg.pin_scl = 10;
            _i2c_bus_instance.config(cfg);
        }

        {
            auto cfg = _panel_instance.config();
            cfg.panel_width = 128;
            cfg.panel_height = 64;
            _panel_instance.setBus(&_i2c_bus_instance);
            _panel_instance.config(cfg);
        }
        setPanel(&_panel_instance);
    };

};

C3GFX lcd;
std::vector<UnitDriveInterface *> drives;

void setup() {
    // put your setup code here, to run once:
    Serial.begin(115200);
    Wire.begin(8, 10, 400000);

    lcd.init();
    lcd.setRotation(2);
    lcd.clear(TFT_BLACK);
    // lcd.drawPng(logo, 5175, 37, 0);

#if defined(FPC_SHT30)
    drives.push_back(new SHT3xDrive(Wire, &lcd));
#elif defined(FPC_SHT40)
    drives.push_back(new SHT4xDrive(Wire, &lcd));
#endif
}


void loop() {
    for (auto &drive : drives) {
        drive->probe();
        drive->init();
        drive->run();
        drive->deinit();
    }
    delay(10);
}
